define([
    'backbone',
    'Layout',
    'modules/appointments/booked/booked-appointments-view',
], function(Backbone, Layout, BookedAppointmentsView) {
    'use strict';

    describe('Booked Appointments View', function() {
        var view;
        var $view;
        var layout = new Layout();
        var appointments = new Backbone.Collection([
            {
                appointmentTime: '12/19/2016 10:40:00',
                appointmentLength: '20',
                clinic: { name: 'ABC CLINIC' },
                facilityName: 'XYZ FACILITY',
                bookingNote: 'Reason, Season, Lifetime',
            },
            {
                appointmentTime: '12/20/2016 09:30:00',
                appointmentLength: '30',
                clinic: { name: 'EFG CLINIC' },
                facilityName: 'ZED FACILITY',
                bookingNote: 'Medication',
            },
        ]);

        // white space preserved in multiline string variables
        // eslint-disable-next-line no-unused-vars
        var appointmentsIcs = 'BEGIN:VCALENDAR\n\
VERSION:2.0\n\
BEGIN:VEVENT\n\
DTSTART:20161219T104000\n\
DTEND:20161220T110000\n\
SUMMARY:Appointment\n\
LOCATION:Clinic: ABC CLINIC\n\
DESCRIPTION:Reason for Visit: Reason, Season, Lifetime\n\
END:VEVENT\n\
BEGIN:VEVENT\n\
DTSTART:20161220T093000\n\
DTEND:20161220T100000\n\
SUMMARY:Appointment\n\
LOCATION:Clinic: EFG CLINIC\n\
DESCRIPTION:Reason for Visit: Medication\n\
END:VEVENT\n\
END:VCALENDAR';

        layout.render();

        beforeEach(function() {
            spyOn(BookedAppointmentsView.prototype, 'showAppointmentsView');
            // ignoring pagination testing because we're adding to a new spec file
            spyOn(BookedAppointmentsView.prototype, 'showPaginationControls').and.callFake(function() {
                // do nothing
            });
            view = new BookedAppointmentsView({ collection: appointments});

            layout.showChildView('content', view);
            $view = view.$el;
        });

        it('has a header', function() {
            expect($view.find('h3').text()).toEqual('Appointments');
        });

        it('has a region to show booked appointments', function() {
            expect($view.has(view.regions.appointmentsListRegion).length).toEqual(1);
            expect($view.has(view.regions.appointmentsListRegion).length).toEqual(1);
        });
        // it("can get the electronic calendar as a string", function(){
        //  expect(view.getCalendar()).toEqual(appointmentsIcs);
        // });
    });
}
);
